<?php
  
class ffImporter{
    private $WPLayer;
    private $replaceRuleActions;
    private $ruleManager;

    private $taxonomies;
    private $posts;
    private $attachments;
    private $menu;
    private $widgets;

	function __construct(){
		$wp_rewrite = new WP_Rewrite();
		global $wp_rewrite;
		
////////////////////////////////////////////////////////////////////////////////
// Load required scripts / classes
////////////////////////////////////////////////////////////////////////////////
		$this->_initRequire();


////////////////////////////////////////////////////////////////////////////////
// Stuff with importer
////////////////////////////////////////////////////////////////////////////////

		$pluginDir = dirname(__FILE__);
		$this->WPLayer = new ffWPLayer();
		$this->WPLayer->set_plugin_dir( $pluginDir );

		$this->replaceRuleActions = new ffReplaceRuleActions();
		$this->ruleManager = new ffRuleManager($this->WPLayer, $this->replaceRuleActions);

		// Featured image
		$ruleFeaturedImage = new ffReplaceRule_FeaturedImage($this->WPLayer, $this->replaceRuleActions);
		$this->ruleManager->addRule( $ruleFeaturedImage );
		
		// Posts
		$rulePostParent = new ffReplaceRule_PostParent($this->WPLayer, $this->replaceRuleActions);
		$this->ruleManager->addRule( $rulePostParent );

		// Meta Galleries, Meta titlebar
		$ruleGalleries = new ffReplaceRule_Galleries($this->WPLayer, $this->replaceRuleActions);
		$ruleGalleries->addGalleryMetaName('freshformat---gallery---gallery');
		$ruleGalleries->addGalleryMetaName('wpgallery---items');
		$this->ruleManager->addRule( $ruleGalleries );

		$rule_PostMeta_ImagesPaths = new ffReplaceRule_PostMeta_ImagesPaths($this->WPLayer, $this->replaceRuleActions);
		$rule_PostMeta_ImagesPaths->addMetaName('titlebar---titlebar-1---background');
		$this->ruleManager->addRule( $rule_PostMeta_ImagesPaths );

		// [Gallery] shortcode, Images
		$ruleGalleryShortcode = new ffReplaceRule_SC_Gallery($this->WPLayer, $this->replaceRuleActions);
		$this->ruleManager->addRule( $ruleGalleryShortcode );

		$rule_SC_VC_Images_attr = new ffReplaceRule_SC_VC_Images_attr($this->WPLayer, $this->replaceRuleActions);
		$this->ruleManager->addRule( $rule_SC_VC_Images_attr );

		$rule_Content_ImagesPaths = new ffReplaceRule_Content_ImagesPaths($this->WPLayer, $this->replaceRuleActions);
		$this->ruleManager->addRule( $rule_Content_ImagesPaths );

		// Widgets
		$ruleWidgetMenus = new ffReplaceRule_WidgetNavigationMenu($this->WPLayer, $this->replaceRuleActions);
		$ruleWidgetMenus->addWidgetAndFieldName('nav_menu', 'nav_menu');
		$ruleWidgetMenus->addWidgetAndFieldName('ffsidemenu', 'custom_menu');
		$this->ruleManager->addRule( $ruleWidgetMenus );

		$this->taxonomies =  new ffImportTaxonomies($this->WPLayer,$this->ruleManager);
		$this->posts =       new ffImportPosts( $this->WPLayer,$this->ruleManager );
		$this->attachments = new ffImportAttachments( $this->WPLayer,$this->ruleManager );
		$this->menu =        new ffImportMenu($this->WPLayer,$this->ruleManager);
		$this->widgets =     new ffImportWidgets($this->WPLayer, $this->ruleManager);

		global $_GET;
		$freshface_import = '';
		if( !empty($_GET['freshface_import']) ){
			$freshface_import = $_GET['freshface_import'];
		}
		$this->import( $freshface_import );
	}
	
	public function import( $what_to_import ){
		$importManager = new ffImportManager( $this->WPLayer,$this->ruleManager );

		switch ($what_to_import){
			case 'attachments':
			        $importManager->addSection( $this->attachments );
			        break;
			case 'taxonomies':
					$importManager->addSection( $this->taxonomies );
					break;
			case 'posts':
					$importManager->addSection( $this->posts );
					break;
			case 'menu':
					$importManager->addSection( $this->menu );
					break;
			case 'widgets':
					$importManager->addSection( $this->widgets );
					break;
			default:
					return;
					break;
		}

		$importManager->loadFileList();
		$importManager->import();
	}

	function _initRequire(){

		require_once(ABSPATH . 'wp-admin/includes/image.php');
		require_once(ABSPATH . 'wp-admin/includes/media.php');

		$loader = array(
				'/classes/basic/ffBasicObject.php',
				'/classes/basic/ffWPLayer.php',
				'/classes/basic/ffWPPost.php',
				'/classes/basic/ffIImportSection.php',
				'/classes/basic/ffImportManager.php',
				'/classes/taxonomies/ffImportTaxonomies.php',
				'/classes/posts/ffImportPosts.php',
				'/classes/attachments/ffImportAttachments.php',
				'/classes/menu/ffImportMenu.php',

				'/classes/widgets/ffImportWidgets.php',

				'/classes/rules/ffIReplaceRule.php',
				'/classes/rules/ffReplaceRule.php',
				'/classes/rules/ffReplaceRuleActions.php',
				'/classes/rules/ffRuleManager.php',

				'/classes/rules/default/ffReplaceRule_FeaturedImage.php',
				'/classes/rules/default/ffReplaceRule_Galleries.php',
				'/classes/rules/default/ffReplaceRule_PostMeta_ImagesPaths.php',
				'/classes/rules/default/ffReplaceRule_SC_Gallery.php',
				'/classes/rules/default/ffReplaceRule_SC_VC_Images_attr.php',
				'/classes/rules/default/ffReplaceRule_Content_ImagesPaths.php',
				'/classes/rules/default/ffReplaceRule_WidgetNavigationMenu.php',
				'/classes/rules/default/ffReplaceRule_PostParent.php',

		);

		$pluginDir = dirname(__FILE__);

		foreach( $loader as $oneFile ) {
			require $pluginDir.$oneFile;
		}
	}
}