
jQuery(document).ready(function($) {
	 
		var current_ed = null;
	
		function framework_shortcodes() {
		    return "[tiny-plugin]";
		}
		
		(function() {
		
		    tinymce.create('tinymce.plugins.framework_shortcodes', {
		
		        init : function(ed, url){
		            ed.addButton('framework_shortcodes', {
		                title : 'Insert TinyPlugin',
		                onclick : function() {
 
		                    someStuff( ed );
		                },
		                image: url + "/shortcode_icon.png"
		            });
		        },
		
		      
		    });
		
		    tinymce.PluginManager.add('framework_shortcodes', tinymce.plugins.framework_shortcodes);
		    
		})();


		function someStuff( ed ) {
			var left = $('.mce_framework_shortcodes').offset().left;
			var top = $('.mce_framework_shortcodes').offset().top;
			
			$('#shortcodes_list_wrapper').css({'top':top, 'left':left, 'display':'block', 'visibility':'visible'}).animate({opacity:1},200);
			
			current_ed = ed;
	
		}
	
	
		var data = {
			action: 'framework_editor',
		};
		
 
		jQuery.post(ajaxurl, data, function(response) {
			$('#wpwrap').append(response);
			});	
			
		$('#shortcodes_list_wrapper').live('mouseleave', function() {
			if( $('#shortcodes_list_wrapper').css('opacity') == 1 )
				$('#shortcodes_list_wrapper').css({'display':'none', 'opacity':0});
 
		});
	
	
		$('#shortcodes_list_wrapper').find('.shortcode_button').live('click', function() {
			var name = $(this).find('span').html();
			var rel = $(this).parent().attr('rel');
			
			if( rel == 'pb_template') {
				current_ed.selection.setContent('[templatebuilder name="' + name + '"]');
			} else {
				var sc_parent = $(this).parent();
				var data_info = sc_parent.find('.data_info');
				
				var type = data_info.find('.type').html();
				var shortcode = data_info.find('.shortcode').html();
				var attributes = '';
				var content = current_ed.selection.getContent();
				
				if( data_info.find('.attributes').find('div').size() > 0 ) {
					data_info.find('.attributes').children('div').each(function() {
						if( 'content' == $(this).attr('data-name') ){
							if( '' === content ){
								content = $(this).attr('data-value');
							}
							return;
						}
						attributes += ' '+$(this).attr('data-name')+'="'+$(this).attr('data-value') + '"';
					});
				}
				
				
				var shortcode_text = '[' + shortcode + attributes + ']';
				if( 'wrapping_content' == type ) {
					shortcode_text += content + '[/' + shortcode.replace(/\s+/,'') + ']';
				}
				
				current_ed.selection.setContent( shortcode_text );
			}
			
	 
			$('#shortcodes_list_wrapper').css('display','none').animate({opacity:0},200);
			return false;
		});
});