jQuery(document).ready(function () {
	jQuery.styleSwitcher();
	reload_styleswitcher_data_by_cookies();
});

(function ($) {
	//main vars
	var switcher;

	// class constructor / "init" function
	$.styleSwitcher = function () {
		isMobile = false;//(Jacked.getMobile() == null) ? false : true;

		//container
		switcher = $('.styleSwitcherWrapper');

		if(isMobile){
			switcher.remove();
		}else{
			initSwitcher();
			initToggle();
		}
	};
	


	/* FIXED HEADER */

	function fixed_header(){

	if ( $('.header_main_wrapper').attr('data-position') == 'fixed') {
		if ( $('.header_main_wrapper').offset.top < 1 ) {
			if ( $(".jqres").width() > 840) { // responsive
				var search_top_overlay_height = 0;
				if ('block' == $('.search_top_overlay').css('display')){
					search_top_overlay_height = $('.search_top_overlay').outerHeight();
				}
				var fixed_header_height = $('.header_main_wrapper').outerHeight() - search_top_overlay_height;
				$('.top_content').css('padding-top', fixed_header_height);
				$('.header_main_wrapper').css('position', 'fixed').css('top','0');
			} else {
				$('.top_content').css('padding-top', '0');
				$('.header_main_wrapper').css('position', 'static');
			}
		}
	}
	
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//INITIATE STYLE SWITCHER
/////////////////////////////////////////////////////////////////////////////////////////////////////////

	function initSwitcher() {

		// SKIN

		$('.switcherSkin a').click(function (e) {

			$('.styleSwitcherPanel .skin_color_section span').attr('style', $(this).attr('style') );

			if ($(this).hasClass('selected')) {
				return false;
			}

			setCookie('switcherSkin', jQuery(this).attr('data-value') );

			// remove orig vals
			orig_val = $('.switcherSkin a.selected').attr('data-value');
			$('.switcherSkin a.selected').removeClass('selected');

			$('#skin-style-css').remove();

			// select
			css_link = $(this).attr('data-value');
			$(this).addClass('selected');

			//css_link = 'skins/'+new_val+'/'+new_val+'.css';
			$('head').append( "<link rel='stylesheet' id='skin-style-css' href='"+css_link+"' type='text/css' media='all' />" );

			setCookie('skin-accent', jQuery(this).attr('data-value') );

			return false;
		});

		// HEADER LAYOUT:  UP / FIXED

		$('.switcherHeaderLayout a').click(function (e) {
			e.preventDefault();

			if ($(this).hasClass('selected')) {
				return;
			}

			setCookie('switcherHeaderLayout', jQuery(this).attr('data-value') );

			headerLayout = $(this).attr('data-value');
			if( 'fixed' == headerLayout ){
				$('.styleSwitcherPanel .header_position span').html('Fixed');
				$('.header_main_wrapper').attr('data-position','fixed').css('position','fixed');
			}else{
				$('.styleSwitcherPanel .header_position span').html('Static');
				$('.header_main_wrapper').attr('data-position','static').css('position','static');

				// logo mar to+bot
				$('a.logo').removeAttr('style');
				// top menu item a - line heig
				$('a.top-menu-item-a').removeAttr('style');
				// search icon marg top
				$('.search_top_button').removeAttr('style');
			}

			$('.switcherHeaderLayout a.selected').removeClass('selected');
			$(this).addClass('selected');

			$(window).setTimeout(function(){
				$(window).resize();
				$(window).scroll();
				$(window).trigger('changeMenuStyle');
			}, 10);

		});

		// GLOBAL PAGE LAYOUT:  BOXED / FULLWIDTH

		$('.skin-use-boxed-layout a').click(function (e) {
			e.preventDefault();

			if( getCookie('skin-use-custom-background-image') ){
				$('.styleSwitcherPanel .skin-use-custom-background-image-on').click();
				_val = $('.styleSwitcherPanel .skin-boxed-background-color').val();
				$('.styleSwitcherPanel .background_image_section span').attr('style', 'background-color:#'+_val);
			}else{
				$('.styleSwitcherPanel .skin-use-custom-background-image-off').click();
			}

			if ($(this).hasClass('selected')) { return; }

			setCookie('skin-use-boxed-layout', jQuery(this).attr('data-value') );

			if( $('body').hasClass('layout_boxed') ){
				$('body').removeClass('layout_boxed');
				$('body').addClass('layout_fullwidth');
				$('.page_layout_section span').html('Fullwidth');
			}else{
				$('body').addClass('layout_boxed');
				$('body').removeClass('layout_fullwidth');
				$('.page_layout_section span').html('Boxed');
			}

			$('.skin-use-boxed-layout a.selected').removeClass('selected');
			$(this).addClass('selected');

			$(window).resize();
		});

		// SKIN LAYOUT: BOXED: BACKGROUND: IMAGE vs COLOR

		$('.skin-use-custom-background-image a').click(function (e) {
			if( $(this).hasClass('skin-use-custom-background-image-on') ){
				setCookie('skin-use-custom-background-image','1');

				_val = $('.styleSwitcherPanel .skin-boxed-background-color').val();
				$('.styleSwitcherPanel .background_image_section span').attr('style', 'background-color:#'+_val);

				$(this).addClass('selected');
				$('.skin-use-custom-background-image-off').removeClass('selected');

				$('.styleSwitcherPanel .skin-boxed-background-image').show();
				$('.styleSwitcherPanel .skin-boxed-background-color-wrapper').hide();
				$('.styleSwitcherPanel .skin-boxed-background-image a[data-value="' + getCookie('skin-boxed-background-image') + '"]').click();
			}else{
				setCookie('skin-use-custom-background-image','');

				$(this).addClass('selected');
				$('.styleSwitcherPanel .skin-use-custom-background-image-on').removeClass('selected');

				$('.styleSwitcherPanel .skin-boxed-background-image').hide();
				$('.styleSwitcherPanel .skin-boxed-background-color-wrapper').show();
				$(".styleSwitcherPanel .skin-boxed-background-color").ColorPickerSetColor( "#" + getCookie('skin-boxed-background-color') );
				$('.styleSwitcherPanel .skin-boxed-background-color').val( getCookie('skin-boxed-background-color') ).change();
			}

			return false;

		});

		// SKIN LAYOUT: BOXED: BACKGROUND = IMAGE
		$('.styleSwitcherPanel .skin-boxed-background-image .predefined-background').click(function (e) {
			setCookie('skin-boxed-background-image', $(this).attr('data-value'));
			$('body').attr('style', $(this).attr('style'));
			$('.styleSwitcherPanel .background_image_section span').attr('style', $(this).attr('style'));
			return false;
		});

		// SKIN LAYOUT: BOXED: BACKGROUND = IMAGE
		$('.styleSwitcherPanel .skin-boxed-background-color').change(function (e) {
			_val = $('.styleSwitcherPanel .skin-boxed-background-color').val();
			setCookie('skin-boxed-background-color', _val );
			$('.styleSwitcherPanel .background_image_section span').attr('style', 'background-color:#'+_val);
			$('body').attr('style', 'background-color:#'+_val);
			$('body').css('background-image', 'url()');
		});

	}

	function initToggle() {

		var switcherOpen = false;
		var btn = $('.styleSwitcherToggle');
		var w = switcher.outerWidth();

		if( getCookie('tmplSwitcherOpened') ) {
			switcher.css('left','0');
			switcherOpen = true;
		}else{
			switcher.css('left',-w);
			switcherOpen = false;
		}

		btn.click(function (e) {
			e.preventDefault();
			switcher.animate({
				left: switcherOpen ? -w : 0
			}, 500);
			switcherOpen = !switcherOpen;
			setCookie('tmplSwitcherOpened',switcherOpen ? '1' : '');
		});
	}
})(jQuery);