<?php

class ffWpHooks{
	static protected $instance;

	function __construct(){
		if( empty( ffWPHooks::$instance ) ){
			ffWPHooks::$instance = $this;
			$this->addHooks();
		}
	}

	private $areHooksAdded = FALSE;

	public function addHooks(){
		if( $this->areHooksAdded ){
			return;
		}

		add_action( 'add_meta_boxes', array($this, 'add_meta_boxes') );
		add_action( 'save_post', array($this, 'save_post') );
		
		$this->areHooksAdded = TRUE;
	}

	// ffOptions

	static function save_post( $ID ){
		global $_POST;
		if( isSet($_POST['action']) )
			if( 'inline-save' == $_POST['action'] )
				return;

		if( !isSet($_POST['post_ID']) ){
			return;
		}

		new ffSalWritepanels( $ID );
	}

	public function add_meta_boxes(){

		$salWP = new ffSalWritepanels();

		if( $salWP->isWritepanelActive() ){

			$post_type = $salWP->getPostType();
			$salWPdata = $salWP->getData();

			foreach($salWPdata->getChilds() as $key=>$wpBoxData) {
				$WP_position = $wpBoxData->getParam('position');
				if( empty($WP_position) ){
					$WP_position = "advanced";
				}

				add_meta_box(
					'ffWritepanel-'.$post_type.'-'.$wpBoxData->getID(),
					$wpBoxData->getTitle(),
					array( new ffPrinterBEWP($wpBoxData) , 'printStructure'),
					$post_type,
					$WP_position
				);
			}
		}
	}
}




