<?php

class ffWidgetRecentPosts extends ffWidget {

	protected $_widgetAdminTitle =       "Recent Posts - Custom Widget";
	protected $_widgetAdminDescription = "Recent Posts with Images";
	protected $_widgetWrapperClasses =   "";
	protected $_widgetFormSize =	 ffWidget::WIDGET_FORM_SIZE_WIDE;

	protected function getImageHTML( $post ){
		$gallery = ffGalleryCollection::getGallery( $post->ID );
		$featuredImage = $gallery->getFeaturedImage();
		
		if( null == $featuredImage ) return null;

		$image = fImg::resize($featuredImage->image->url, 52, 52, true );
		$ret  = '<div class="recent_post_left">';
		$ret .= '<a href="'.get_permalink($post->ID).'">';
		$ret .= '<div class="recent_post_image">';
		$ret .= '<img src="'.$image.'"
				 alt="'.$featuredImage->altText.'"
				 title="'.$featuredImage->title.'"
				 width="52"
				 height="52" />';
		$ret .= '</div>';
		$ret .= '</a>';
		$ret .= '</div>';
		return $ret;
	}

	protected function getVideoImageHTML( $post ){

		$video = new ffVideo( ffWP::get( 'freshformat video link', $post->ID ) );
		
		$featuredImage = $video->getFeaturedImage();
		
		if( null == $featuredImage ) return null;

		$ret  = '<div class="recent_post_left">';
		$ret .= '<a href="'.get_permalink($post->ID).'">';
		$ret .= '<div class="recent_post_image">';
		$ret .= '<img src="'.$featuredImage.'"
				 alt=""
				 width="52" />';
		$ret .= '</div>';
		$ret .= '</a>';
		$ret .= '</div>';
		return $ret;
	}


	function widget( $args, $instance ) {
		
		extract( $args );
		$data = $this->load($instance);
		
		echo $before_widget;
		
		$title = trim( $data->Get('title') );
		if( !empty($title) ){
			echo $before_title . $title . $after_title;
		}
		
		$getPostArgs['posts_per_page'] = $data->Get('number-of-posts');
		$getPostArgs['category'] = $data->Get('categories');
		
		$posts = get_posts($getPostArgs) ;
		
		if( !empty( $posts ) ) {
			echo '<ul class="recent_posts_custom">';
			foreach( $posts as $onePost ) {
				//var_dump( $onePost );

				$image = $this->getImageHTML( $onePost );

				// This print image and returns true if printed
				if( empty( $image ) ){
					if( 'video' == ffWP::get( 'freshformat type', $onePost->ID ) ){
						$image = $this->getVideoImageHTML( $onePost );
					}
				}

				if( empty( $image ) ){
					continue;
				}

				echo '<li>';

				echo $image;

				echo '<div class="recent_post_right">';
				echo '<a class="recent_post_title" href="'.get_permalink($onePost->ID).'">'.$onePost->post_title.'</a>';
				echo '<div class="recent_post_date">';
				echo get_the_time( get_option('date_format'), $onePost->ID );
				echo '</div>';
				echo '<a class="recent_post_comments_number" href="'.get_permalink($onePost->ID).'#comments"><i class="icon-comments"></i>'.$onePost->comment_count.'</a>';
                echo ff_i_recommend_this($onePost->ID);
				echo '</div>';
				echo '</li> ';
			}
			echo '</ul>';
		}
		
		echo $after_widget;

	}
}


