<?php

class totranslation{

	static function createStructure(){

		$html_before = '<span class="imgitem_container"><span class="imgitem_wrapper"><span class="imgitem" style="padding:0 20px">';
		$html_after =  '</span></span></span>';

		if( !defined('WPLANG')){
			$default_lang = 'en';
		}else{
			$default_lang = WPLANG;
			if( empty($default_lang) ){
				$default_lang = 'en';
			}else{
				$default_lang = substr($default_lang, 0, 2);
			}
		}

		$default_lang = strtolower($default_lang);

		if( class_exists('SitePress') ){
			$langs = array();
			global $sitepress;
			foreach ($sitepress->get_active_languages() as $key => $value) {
				$langs[ strtolower( $key ) ] = $html_before . $value['native_name'] . $html_after ;
			}
		}else{
			$langs = array( $default_lang  => $default_lang );
		}

		$a = new ffStructure();

		$a->startSection( 'translation', 'Translation');

			if( count($langs) > 1 ) {
				$a->addElement( ffOptEnv::HEADER, 'Language' );

				$a->addOption(ffOptEnv::TABS, 'lang', '', $default_lang )
					->addParam('tabs', $langs);
			}

			foreach ($langs as $lang_key => $value) {

				$a->startSection( $lang_key, '');

					$a->addElement( ffOptEnv::HEADER, 'Translation section' );

					$a->addOption(ffOptEnv::TABS, 'transtabs', '', 'post' )
						->addParam('tabs', array(
							'post' => $html_before . 'Posts' . $html_after,
							'portfolio' => $html_before . 'Portfolio' . $html_after,
							'pagination' => $html_before . 'Pagination' . $html_after,
							'search' => $html_before . 'Search' . $html_after,
							'page404' => $html_before . 'Page 404' . $html_after,
							'comment' => $html_before . 'Comments' . $html_after,
							'months' => $html_before . 'Months' . $html_after,
						)
					);

					$a->startSection( 'post', '');
						$a->addElement( ffOptEnv::HEADER, 'Posts' );
						$a->addOption( ffOptEnv::TEXT, 'posted-by', 'Posted by [author link]', 'Posted by %s');
						$a->addOption( ffOptEnv::TEXT, 'read-more', 'Read more button', 'Read More');
						$a->addOption( ffOptEnv::TEXT, 'share', 'Share this story (title)', 'Share this Story');
						$a->addOption( ffOptEnv::TEXT, 'about-author', 'About [author]', 'About %s');
					$a->endSection();
					
					$a->startSection( 'portfolio', '');
						$a->addElement( ffOptEnv::HEADER, 'Portfolio Category Sorting' );
						$a->addOption( ffOptEnv::TEXT, 'sort-portfolio', 'Sort Portfolio', 'Sort Portfolio');
						$a->addOption( ffOptEnv::TEXT, 'all-works', 'All Works', 'All Works');
						$a->addOption( ffOptEnv::TEXT, 'project-count-label', 'Project Count Label', 'Projects');

						$a->addElement( ffOptEnv::HEADER, 'Portfolio' );
						$a->addOption( ffOptEnv::TEXT, 'date-format', 'Date Format', 'F j, Y');
						$a->addOption( ffOptEnv::TEXT, 'post-by', 'Posts by [author link]', 'Posts by %s');
						$a->addOption( ffOptEnv::TEXT, 'posted-in', 'Posted in [category list]', 'Posted in %s');
						
						$a->addOption( ffOptEnv::TEXT, 'read-more', 'Read more button', 'Read more');
						$a->addOption( ffOptEnv::TEXT, 'time-ago', 'Time ago', __('%s ago', 'default'));
						
						$a->addOption( ffOptEnv::TEXT, 'posted-date-single', 'Posted: (single meta)', __('Posted:', 'default'));
						
						$a->addOption( ffOptEnv::TEXT, 'share', 'Share', 'Share');
					$a->endSection();

					$a->startSection( 'pagination', '');
						$a->addElement( ffOptEnv::HEADER, 'Pagination' );
						$a->addOption( ffOptEnv::TEXT, 'of', 'Page [1] of [5]', 'Page %s of %s');
					$a->endSection();

					$a->startSection( 'search', '');
						$a->addElement( ffOptEnv::HEADER, 'Search' );
						$a->addOption( ffOptEnv::TEXT, 'navigation-placeholder', 'Navigation Search Placeholder', __('Search...', 'default'));
						$a->addOption( ffOptEnv::TEXT, 'titlebar_title', 'Search results for "%s"', __('Search Results for: %s', 'default') );
						$a->addOption( ffOptEnv::TEXT, 'title', 'Search page title', 'Search our site');
						$a->addOption( ffOptEnv::TEXT, 'placeholder', 'Placeholder', 'Enter keywords ..');
						$a->addOption( ffOptEnv::TEXT, 'nothing_found', 'Nothing found', __('Nothing Found', 'default').'.');
					$a->endSection();

					$a->startSection( 'page404', 'Page 404');
						$a->addElement(ffOptEnv::HEADER, '404 Page');
						$a->addOption(ffOptEnv::TEXT, 'title', 'Title', '404' );
						$a->addOption(ffOptEnv::TEXTAREA, 'content', 'Content', 'Sorry but we couldn\'t find the page you are looking for. Please check to make sure you\'ve typed the URL correctly. You may also want to search for what you are looking for.' );
						$a->addOption(ffOptEnv::TEXT, 'return', 'Return to previous page', 'Return to the Previous Page' );
					$a->endSection();

					$a->startSection( 'comment', '');
						$a->addElement( ffOptEnv::HEADER, 'Comments count' );
							$a->addOption(ffOptEnv::TEXT, 'comments-zero', '0 Comments', __('No Comments', 'default'));
							$a->addOption(ffOptEnv::TEXT, 'comments-one', '1 Comment', __('1 Comment', 'default'));
							$a->addOption(ffOptEnv::TEXT, 'comments-more', '%s Comments', __('% Comments', 'default'));

						$a->addElement( ffOptEnv::HEADER, 'Comments list' );
							$a->addOption(ffOptEnv::TEXT, 'user_says', 'User says:', '%s says:');
							$a->addOption(ffOptEnv::TEXT, 'user_date_format', 'User date format', 'M j Y');
							$a->addOption(ffOptEnv::TEXT, 'user_time_format', 'User date format', 'g:i a');
							$a->addOption(ffOptEnv::TEXT, 'user_comment_meta', 'User comment meta (date, time, reply)', '%s %s %s');

						$a->addElement( ffOptEnv::HEADER, 'Comment form' );
							$a->addOption( ffOptEnv::TEXT, 'title_reply', 'Comment form title', __('Leave a Reply', 'default'));
							$a->addOption( ffOptEnv::TEXT, 'title_reply_to', 'Leave reply to %', __('Leave a Reply to %s', 'default'));
							$a->addOption( ffOptEnv::TEXT, 'cancel_reply_link', 'Cancel reply', __('Cancel Reply', 'default'));

							$a->addOption( ffOptEnv::TEXTAREA, 'logged_in_as', 'Logged as', __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>' ) );

							$a->addOption( ffOptEnv::TEXT, 'author', 'Author Name', __('Name', 'default'));
							$a->addOption( ffOptEnv::TEXT, 'email', 'Author Email', __('Email', 'default'));
							$a->addOption( ffOptEnv::TEXT, 'website', 'Author Website', __('Website', 'default'));
							$a->addOption( ffOptEnv::TEXT, 'comment_title', 'Comment', _x( 'Comment', 'noun', 'default' ));

							$a->addOption( ffOptEnv::TEXT, 'label_submit', ' Submit Comment Button', __('Post Comment', 'default'));
							$a->addOption( ffOptEnv::TEXT, 'reply', ' Reply Button', __('Reply', 'default'));

							$a->addOption( ffOptEnv::TEXTAREA, 'comment_notes_before', 'Notes before comment form', __( 'Your email address will not be published.', 'default' ) );
							$a->addOption( ffOptEnv::TEXTAREA, 'comment_notes_after', 'Notes after comment form', 
									sprintf(
									__( 'You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s' ),
									' <code>' . allowed_tags() . '</code>'
									)
							);

							$a->addElement( ffOptEnv::HEADER, 'Comments navigation' );

							$a->addOption(ffOptEnv::TEXT, 'prev', 'Previous Comments', '&laquo; ' . __('Previous Comments', 'default'));
							$a->addOption(ffOptEnv::TEXT, 'next', 'Next Comments', __('Next Comments', 'default') . ' &raquo;');
	
					$a->endSection();

					$a->startSection( 'months', '');

						$a->addElement(ffOptEnv::HEADER, 'Long Month name');

						foreach ( array( 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 
										'September', 'October', 'November', 'December' ) as $month_index => $month_name) {
							$a->addOption(ffOptEnv::TEXT, 'long_name_'.(1+$month_index) , $month_name, $month_name );
						}

						$a->addElement(ffOptEnv::HEADER, 'Short Month name');

						foreach ( array( 'jan','feb','mar','apr','may','jun','jul','aug','sep','oct','nov','dec' ) 
										as $month_index => $short_month_name) {
							$a->addOption(ffOptEnv::TEXT, 'short_name_'.(1+$month_index) , $short_month_name, $short_month_name );
						}

					$a->endSection();

				$a->endSection();
		
			} // foreach ($langs as $lang_key => $value) {				
		$a->endSection();

		return $a;

	}

}
