<?php
class toskin{
	static function getSkinsAccents(){
		$html_before = '<span class="imgitem_container"><span class="imgitem_wrapper"><span class="imgitem">';
		$html_after =  '</span></span></span>';
		
		$accent_tabs = array();
		
		foreach ( array(
				'burgundy' => 'background-color: #e52b50;',
				'magenta'  => 'background-color: #f20707;',
				'red'      => 'background-color: #ff3500;',
				'orange'   => 'background-color: #ff760d;',
				'pink'     => 'background-color: #de66c2;',
				'cobalt'   => 'background-color: #277edc;',
				'blue'     => 'background-color: #0093cf;',
				'cyan'     => 'background-color: #27ccc0;',
				'green'    => 'background-color: #71be3c;',

			) as $key=>$style) {
			
	            $accent_tabs[$key] = 
	        		$html_before
					. '<span title="'.$key.'" style="'.$style.';display:inline-block;height:50px;line-height:50px;width:50px"> &nbsp; </span>'
					. $html_after;

		}

		return $accent_tabs;
	}


	static function createStructure(){


		$a = new ffStructure();
		$a->startSection( 'skin', 'Skins');

			$a->addElement(ffOptEnv::HEADER, 'Accent Color');

			$a->addOption(ffOptEnv::TABS, 'accent', '', 'blue' )
				->addParam('tabs', toskin::getSkinsAccents() );

			$a->addElement(ffOptEnv::HEADER, 'Boxed Layout');
			$a->addOption(ffOptEnv::CHECKBOX, 'use-boxed-layout', 'Use Boxed Layout')
				->addParam('enables', 'boxed' );

			$a->startSection( 'boxed', '' );
				$a->addOption(ffOptEnv::COLORPICKER, 'background-color', 'Background Color','#ffffff' );

				$a->addOption(ffOptEnv::CHECKBOX, 'use-background-image', 'Use background image')
					->addParam('enables', 'background-image|background-predefined|background-position|background-position|background-size|background-repeat' );
				$a->addOption(ffOptEnv::IMAGE, 'background-image', 'Background Image', get_template_directory_uri().'/images/boxed_fabric.jpg');

				$a->addOption(ffOptEnv::TABS, 'background-predefined', '' )
					->addParam('tabs', toskin::getPredefinedBoxedBackgrounds(), '', 'boxed_fabric' );

				$a->addOption(ffOptEnv::SELECT, 'background-position', 'Background Position', 'left top')
						->addSelectValue('static','static')
						->addSelectValue('left top','left top')
						->addSelectValue('left center','left center')
						->addSelectValue('left bottom','left bottom')
						->addSelectValue('right top','right top')
						->addSelectValue('right center','right center')
						->addSelectValue('right bottom','right bottom')
						->addSelectValue('center top','center top')
						->addSelectValue('center center','center center')
						->addSelectValue('center bottom','center bottom');

				$a->addOption(ffOptEnv::SELECT, 'background-size', 'Background Size', 'cover')
						->addSelectValue('auto', 'auto')
						->addSelectValue('contain', 'contain')
						->addSelectValue('cover', 'cover');

				$a->addOption(ffOptEnv::SELECT, 'background-repeat', 'Background Repeat', 'repeat')
						->addSelectValue('no-repeat', 'no-repeat')
						->addSelectValue('repeat-x', 'repeat-x')
						->addSelectValue('repeat-y', 'repeat-y')
						->addSelectValue('repeat', 'repeat');

				$a->addElement(ffOptEnv::HTML, toskin::getPredefinedBoxedBackgroundsJavascript());

			$a->endSection();
			
			
			$a->addOption(ffOptEnv::CHECKBOX, 'use-custom-colors', 'Use Custom Colors')
			->addParam('enables', 'custom-colors' );
			$a->startSection( 'custom-colors', '' );
				/*
				 * $accent
					$accent-postauthor-1 // background color
					$accent-postauthor-2 // border
					$accent-portfolio-image-zoom // background color
					$accent-text-icon-block-shadow // shadow
					$accent-expand-wrapper // border color
					$accent-rgba

				 */
				$a->addOption(ffOptEnv::COLORPICKER, 'accent', 'General Color', '#0093cf');
				$a->addOption(ffOptEnv::COLORPICKER, 'accent-postauthor-1', 'Comment Author Background', '#0093cf');
				$a->addOption(ffOptEnv::COLORPICKER, 'accent-postauthor-2', 'Comment Author Inner', '#0093cf');
				$a->addOption(ffOptEnv::COLORPICKER, 'accent-portfolio-image-zoom', 'Portfolio Image Zoom', '#0093cf');
				$a->addOption(ffOptEnv::COLORPICKER, 'accent-text-icon-block-shadow', 'Text with icon Black shadow', '#0093cf');
				$a->addOption(ffOptEnv::COLORPICKER, 'accent-expand-wrapper', 'Text With Icon Expand', '#0093cf');
				$a->addOption(ffOptEnv::COLORPICKER, 'accent-rgba', 'RGBA color', '#0093cf');
			$a->endSection();
		$a->endSection();
		return $a;
	}

	static function getPredefinedBoxedBackgrounds(){

		$ff_theme_background_settings = array(
			'boxed_fabric'        => 'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_fabric.jpg\'); background-color: #555555',
			'boxed_wood'          => 'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_wood.jpg\'); background-color: #f5d29d',
			'boxed_2'          => 'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_2.jpg\'); background-color: #f0f0f0',
			'boxed_3'          => 'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_3.jpg\'); background-color: #f0f0f0',
			'boxed_5'          => 'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_5.jpg\'); background-color: #f0f0f0',
			'boxed_8'          => 'background-image: url(\'' . get_template_directory_uri() . '/images/boxed_8.jpg\'); background-color: #f0f0f0',
		);
		
		$html_before = '<span class="imgitem_container"><span class="imgitem_wrapper"><span class="imgitem">';
		$html_after = '</span></span></span>';
        foreach ($ff_theme_background_settings as $key=>$value) {
            $ff_theme_background_settings[ $key ] = $html_before
						. '<span class="skin-predefined-boxed-layout" style="'
						. $value
						. ';display:inline-block;height:100px;line-height:100px;width:150px"> &nbsp; </span>'
						. $html_after;
        }
        return $ff_theme_background_settings;
	}

	static function getPredefinedBoxedBackgroundsJavascript(){

		return '

		<script>
			jQuery(".skin-predefined-boxed-layout").click(function(){
				_img = jQuery(this).css("background-image");
				_img =_img.substr(4, _img.length - 5);
				jQuery("#skin---boxed---background-image").val( _img );

				_color = jQuery(this).css("background-color");
				if( _color ){
					if (_color.substr(0, 1) != "#") {
						digits = /(.*?)rgb\((\d+), (\d+), (\d+)\)/.ex' . /* WTF themecheck this is javascript exec is JS function too! */ 'ec(_color);
						red = parseInt(digits[2]);
						green = parseInt(digits[3]);
						blue = parseInt(digits[4]);
						rgb = blue | (green << 8) | (red << 16);
                        _color = "#" + rgb.toString(16);
					}
					jQuery("#skin---boxed---background-color").ColorPickerSetColor( _color );
					jQuery("#skin---boxed---background-color").val( _color );
					jQuery("#skin---boxed---background-color").css( "background-color", _color );
					jQuery("#skin---boxed---background-color").change();
				}
				
				_size = jQuery(this).css("background-size");
				if( ( _size ) && ( "cover" == _size ) ){
					jQuery("#skin---boxed---background-size").val( _size );
				}else{
					jQuery("#skin---boxed---background-size").val( "auto" );
				}

			});
		</script>

		';
	}
}
