<?php
  
class ffSP{

	static $instances = array();
	static $inst_data = array();
	
	protected $tax_ID;
	protected $tax_name;
	protected $data;

	static function get_term_taxonomy(){
		if( is_home() or is_front_page()  ){ return "home"; }
		if( is_author() ){ return "archives"; }
		if( is_search() ){ return "archives"; }
		if( is_date()   ){ return "archives"; }
		if( is_single() ){ 
			if( is_singular('post') ){
				return "category"; 
			}

			if( is_singular('portfolio') ){
				return FF_PORTFOLIO_CATEGORY_SLUG; 
			}

			return "category"; 
		}

		global $wp_query;
		$tax_name = $wp_query->tax_query->queries[0]['taxonomy'];
		return $tax_name;
	}

	static function get_term_id($tax_name = null){
		if( is_home()   ){ return 0; }
		if( is_author() ){ return 0; }
		if( is_search() ){ return 0; }
		if( is_date()   ){ return 0; }
		if( is_single() ){ 
			$_sp_post_ID = get_queried_object_id();
			
			$_sp_post_terms = false;

			if( is_singular('post' ) ){ 
				$_sp_post_terms = get_the_terms( $_sp_post_ID, 'category' ); 
			}else if( is_singular('portfolio') ){ 
				$_sp_post_terms = get_the_terms( $_sp_post_ID, FF_PORTFOLIO_CATEGORY_SLUG ); 
			}else{
				return 0;
			}

			if( empty( $_sp_post_terms ) or is_wp_error( $_sp_post_terms ) ){
				return 0;
			}

			// SRY, this is kind of hack ...
			foreach ($_sp_post_terms as $term_ID => $term_array) {
				return $term_ID;
			}
		}

		if( null == $tax_name ){
			$tax_name = ffSP::get_term_taxonomy();
		}

		global $wp_query;

		if( is_category() ){
			if( ! empty ( $wp_query->query['cat'] ) ){
				return $wp_query->query['cat'];
			}

			$t = get_category_by_slug( $wp_query->query['category_name'] );
			return $t->term_id ;
		}else if( is_tag() ){
			$t = get_term_by('slug', $wp_query->query['tag'], 'post_tag');
			return $t->term_id ;
		}else if( taxonomy_exists( $tax_name ) ){
			if( empty( $wp_query->query[$tax_name] ) ){
				return 0;
			}
			$slug = $wp_query->query[$tax_name];
			$term = get_term_by('slug',$slug, $tax_name);
			$tax_ID = $term->term_id;
			return 1*$tax_ID;
		}
		return 0;
	}

	function __construct( $tax_name, $tax_ID ){
		$this->tax_ID = $tax_ID;
		$this->tax_name = $tax_name;
		
		if( FF_PORTFOLIO_CATEGORY_SLUG == $tax_name ){
			$sal = new ffSalSPFE( 'portfolio-category', $tax_ID );
		}else{
			$sal = new ffSalSPFE( $tax_name, $tax_ID );
		}

		$this->data = $sal->getData();
		if(empty(ffSP::$instances[ $tax_name ])){
			ffSP::$instances[ $tax_name ] = array();
		}
		ffSP::$instances[ $tax_name ][ $tax_ID ] = $this;
	}
	
	static function init( $tax_name=NULL, $tax_ID=NULL ){
		if( NULL === $tax_name ) {
			$tax_name = ffSP::get_term_taxonomy();
		}
		if( NULL === $tax_ID ) {
			$tax_ID = ffSP::get_term_id( $tax_name );
		}
		if( empty( ffSP::$instances[ $tax_name ][ $tax_ID ] ) ){
			new ffSP($tax_name, $tax_ID);
		}
		return ffSP::$instances[ $tax_name ][ $tax_ID ];
	}

	static function setDBDirect( $name, $tax_name, $tax_ID, $value ){
		$opt = get_option( ffSalSPDB::getName( $tax_name ), null );
		if( ! is_array( $opt ) ){
			$opt = array();
		}
		if( ! is_array( $opt[$tax_ID] ) ){
			$opt[$tax_ID] = array();
		}
		$opt[$tax_ID][ $name ] = $value;
		update_option( ffSalSPDB::getName( $tax_name ), $opt );
	}

	static function get($name, $tax_name=NULL, $tax_ID=NULL ){
		$name = strtolower($name);
		return ffSP::init( $tax_name, $tax_ID )->data->get($name);
	}

	public static function getLoopParams(){
		switch ( ffSP::get_term_taxonomy() ) {

			case 'home':
			case 'category':
			case FF_PORTFOLIO_CATEGORY_SLUG: // 'portfolio-category'
			case 'post_tag':
			case 'archives':
				// Its OK
				break;

			default:
				return null;
				break;

		}

		$params = array();

		$params['posts_per_page'] = ffSP::get('query posts_per_page');
		if( empty($params['posts_per_page']) ){
			$params['posts_per_page'] = 987654321;
		}
		
		$params['numberposts'] = $params['posts_per_page'];

		$params['order'] = ffSP::get('query order');

		$params['order_by'] = ffSP::get('query order_by');

		return $params;
	}

}